# Backend SENADIAC

**Empresa Desenvolvedora:** Egrégora  
**Framework:** [Laravel 12](https://laravel.com/)  
**Arquitectura:** Hexagonal (Ports & Adapters)  
**Infraestrutura:** [Laravel Sail](https://laravel.com/docs/master/sail) com Docker + PostgreSQL  

---

## 📌 Índice

- [Backend SENADIAC](#backend-senadiac)
  - [📌 Índice](#-índice)
  - [📖 Descrição](#-descrição)
  - [🛠 Pré-requisitos](#-pré-requisitos)
  - [📥 Clonar e instalar](#-clonar-e-instalar)
  - [⚙️ Configuração do ambiente](#️-configuração-do-ambiente)
  - [▶️ Rodar o projecto](#️-rodar-o-projecto)
  - [🏗 Estrutura de pastas (Arquitectura Hexagonal)](#-estrutura-de-pastas-arquitectura-hexagonal)
  - [💻 Comandos úteis](#-comandos-úteis)
  - [🧪 Testes](#-testes)
  - [🗄 Migrações e Seeders](#-migrações-e-seeders)
  - [🐛 Troubleshooting](#-troubleshooting)
    - [Porta 80 já em uso](#porta-80-já-em-uso)
    - [Serviço `laravel.test` não está a correr](#serviço-laraveltest-não-está-a-correr)
    - [Base de Dados não conecta](#base-de-dados-não-conecta)
  - [📚 Documentação extra](#-documentação-extra)
  - [👨‍💻 Equipa de desenvolvimento](#-equipa-de-desenvolvimento)

---

## 📖 Descrição

O **Backend SENADIAC** é uma API desenvolvida em **Laravel 12**, com suporte oficial a Docker via **Laravel Sail**, utilizando **PostgreSQL** como base de dados.  

O projecto segue **Arquitectura Hexagonal (Ports & Adapters)** para manter independência de frameworks, alta testabilidade e flexibilidade em integrações externas.

---

## 🛠 Pré-requisitos

Antes de começar, garanta que tens:

- [Docker](https://docs.docker.com/get-docker/) ≥ 20.x  
- [Docker Compose](https://docs.docker.com/compose/install/) ≥ 2.x  
- [Git](https://git-scm.com/) ≥ 2.x  
- [PHP ≥ 8.2](https://www.php.net/) e [Composer](https://getcomposer.org/) se quiseres rodar fora do Docker  

---

## 📥 Clonar e instalar

1. **Clona o repositório:**

```bash
git clone https://github.com/egr-egora/backend-senadiac.git
cd backend-senadiac
```

2. **Instala dependências PHP:**

```bash
composer install
```

3. **Instala dependências JS (se aplicável):**

```bash
npm install && npm run dev
```

---

## ⚙️ Configuração do ambiente

1. Copia o arquivo de exemplo `.env`:

```bash
cp .env.example .env
```

2. Gera a `APP_KEY`:

```bash
./vendor/bin/sail artisan key:generate
```

3. Verifica se as variáveis de ambiente do DB estão correctas no `.env`:

```env
DB_CONNECTION=pgsql
DB_HOST=pgsql
DB_PORT=5432
DB_DATABASE=senadiac
DB_USERNAME=sail
DB_PASSWORD=password
```

4. Define a porta da aplicação (se a 80 já estiver em uso):

```env
APP_PORT=8080
```

---

## ▶️ Rodar o projecto

1. **Subir containers (Laravel + Postgres):**

```bash
./vendor/bin/sail up -d
```

2. **Executar migrations:**

```bash
./vendor/bin/sail artisan migrate
```

3. **Aceder à API:**

```
http://localhost:8080
```

(ou `http://localhost` se `APP_PORT=80`)

---

## 🏗 Estrutura de pastas (Arquitectura Hexagonal)

```bash
app/
├─ Domain/                  # Regras de negócio (não depende de Laravel)
│  ├─ Entities/             # Entidades de domínio (ex: Ticket, User, etc.)
│  ├─ Repositories/         # Interfaces (ports)
│  └─ Exceptions/
├─ Application/             # Casos de uso (serviços de aplicação)
│  ├─ DTOs/                 # Data Transfer Objects
│  └─ UseCases/             # Lógica de orquestração (chamam domain e ports)
├─ Infrastructure/          # Adapters (implementações concretas)
│  ├─ Persistence/          # Eloquent, Postgres, Redis, etc.
│  │  ├─ Eloquent/Models/
│  │  └─ Repositories/
│  └─ Providers/            # ServiceProviders (bindings)
├─ UI/                      # Interface com o "mundo externo"
│  ├─ Http/
│  │  ├─ Controllers/
│  │  └─ Requests/
│  └─ Routes/               # api.php / web.php
```

Essa estrutura separa responsabilidades e mantém o **domínio independente** do framework.

---

## 💻 Comandos úteis

- Subir containers:

```bash
./vendor/bin/sail up -d
```

- Parar containers:

```bash
./vendor/bin/sail down
```

- Rebuild containers:

```bash
./vendor/bin/sail build --no-cache
```

- Aceder ao bash do container:

```bash
./vendor/bin/sail bash
```

- Rodar migrations:

```bash
./vendor/bin/sail artisan migrate
```

- Rodar seeds:

```bash
./vendor/bin/sail artisan db:seed
```

---

## 🧪 Testes

Rodar testes com PHPUnit:

```bash
./vendor/bin/sail test
```

Ou PHPUnit direto:

```bash
./vendor/bin/sail phpunit
```

---

## 🗄 Migrações e Seeders

- Criar nova migration:

```bash
./vendor/bin/sail artisan make:migration create_example_table
```

- Criar novo seeder:

```bash
./vendor/bin/sail artisan make:seeder ExampleSeeder
```

- Executar migrations + seeders:

```bash
./vendor/bin/sail artisan migrate --seed
```

---

## 🐛 Troubleshooting

### Porta 80 já em uso

Erro:

```
failed to bind host port for 0.0.0.0:80: address already in use
```

➡️ Solução: altera `APP_PORT=8080` no `.env`.

### Serviço `laravel.test` não está a correr

- Verifica logs:

```bash
./vendor/bin/sail logs laravel.test
```

- Faz rebuild:

```bash
./vendor/bin/sail down -v
./vendor/bin/sail build --no-cache
./vendor/bin/sail up -d
```

### Base de Dados não conecta

Confirma se `.env` tem `DB_HOST=pgsql` (nome do serviço Docker).

---

## 📚 Documentação extra

- [Laravel 12 Docs](https://laravel.com/docs)  
- [Laravel Sail Docs](https://laravel.com/docs/sail)  
- [Docker Docs](https://docs.docker.com/)  
- [PostgreSQL Docs](https://www.postgresql.org/docs/)  

---

## 👨‍💻 Equipa de desenvolvimento

**Egrégora** — Soluções de Engenharia de Software  
Projecto **Backend SENADIAC**  

---
