<?php

namespace Application\DTOs;

class UpdateObraDTO
{
    public int $id;
    public string $titulo;
    public string $numero_certificado;
    public string $data_registo;
    public int $provincia_id;
    public int $genero_id;
    public string $suporte;
    public int $classificacao_id;
    public string $obra_intelectual;
    public ?string $descricao;
    public ?string $observacoes;
    public array $autores;
    public array $documentos;

    // Dados de publicação (quando obra_intelectual = 'PUBLICADA')
    public ?string $editora;
    public ?string $num_edicao;
    public ?int $ano;
    public ?string $produtora;
    public ?string $local_publicacao;
    public ?string $volume;

    public function __construct(
        int $id,
        string $titulo,
        string $numero_certificado,
        string $data_registo,
        int $provincia_id,
        int $genero_id,
        string $suporte,
        int $classificacao_id,
        string $obra_intelectual,
        array $autores,
        array $documentos = [],
        ?string $descricao = null,
        ?string $observacoes = null,
        ?string $editora = null,
        ?string $num_edicao = null,
        ?int $ano = null,
        ?string $produtora = null,
        ?string $local_publicacao = null,
        ?string $volume = null
    ) {
        $this->id = $id;
        $this->titulo = $titulo;
        $this->numero_certificado = $numero_certificado;
        $this->data_registo = $data_registo;
        $this->provincia_id = $provincia_id;
        $this->genero_id = $genero_id;
        $this->suporte = $suporte;
        $this->classificacao_id = $classificacao_id;
        $this->obra_intelectual = $obra_intelectual;
        $this->autores = $autores;
        $this->documentos = $documentos;
        $this->descricao = $descricao;
        $this->observacoes = $observacoes;
        $this->editora = $editora;
        $this->num_edicao = $num_edicao;
        $this->ano = $ano;
        $this->produtora = $produtora;
        $this->local_publicacao = $local_publicacao;
        $this->volume = $volume;
    }
}
