<?php

namespace Application\Shared\Search;

enum Operator: string
{
    case LIKE = 'like';
    case EQ = 'eq';
    case NEQ = 'neq';
    case GTE = 'gte';
    case LTE = 'lte';
    case IN = 'in';
    case BETWEEN = 'between';

    public function toSql(): string
    {
        return match ($this) {
            self::LIKE => 'LIKE',
            self::EQ => '=',
            self::NEQ => '!=',
            self::GTE => '>=',
            self::LTE => '<=',
            self::IN => 'IN',
            self::BETWEEN => 'BETWEEN',
        };

    }
    public function requiresArray(): bool 
    {
        return is_array($this, [self::IN, self::BETWEEN], true);
    }
}
