<?php
namespace Application\Shared\Search;

class SearchWithPagination
{
    public Search $search;
    public Paginate $paginate;

    public function __construct(Search $search, Paginate $paginate)
    {
        $this->search = $search;
        $this->paginate = $paginate;
    }

    public static function fromArray(array $data): self
    {
        $search = new Search($data);
        $paginate = new Paginate($data);
        return new self($search, $paginate);
    }
}