<?php

namespace Application\UseCases;

use Domain\Entities\Genero;
use Domain\Repositories\IGeneroRepositoryInterface;

class CreateGenero
{
    public function __construct(private IGeneroRepositoryInterface $repo)
    {
    }


    public function execute(string $designacao): Genero
    {
        $genero = new Genero($designacao);
        return $this->repo->save($genero);
    }
}
