<?php
namespace Application\UseCases;

use Domain\Repositories\IDocumentRepository;
use Domain\Services\IFileDelete;
use DomainException;
class DeleteAuthorDocument
{
  
    public function __construct(
        private IDocumentRepository $documentRepository,
        private IFileDelete $fileDelete,
    
    )
    {
    }
    public function execute( int $authorId, int $documentId,): void
    {
     
        $findDocument = $this->documentRepository->findById($documentId);
        if (!$findDocument) {
            throw new DomainException('Documento Não Encontrado');
        }

        $authorDocument = $this->documentRepository->belongsToAuthor($documentId, $authorId);
        if (!$authorDocument) {
            throw new DomainException('O Documento Não Pertence ao Autor');
        }

        $this->fileDelete->delete($findDocument->caminho_arquivo);
        $this->documentRepository->deleteAuthorDocument($documentId);
    }
}