<?php

namespace Application\UseCases;

use Domain\Repositories\IObraRepository;
use Domain\Repositories\IAutorObraRepository;
use Infrastructure\Persistence\Eloquent\Models\AutorModel;
use DomainException;

class RemoveAutorObra
{
    public function __construct(
        private IObraRepository $obraRepository,
        private IAutorObraRepository $autorObraRepository
    ) {}

    public function execute(int $obraId, int $autorId): array
    {
        $obra = $this->obraRepository->findById($obraId);
        if (!$obra) {
            throw new DomainException('Obra não encontrada');
        }

        $autor = AutorModel::find($autorId);
        if (!$autor) {
            throw new DomainException('Autor não encontrado');
        }

        $autorObras = $this->autorObraRepository->findByObra($obraId);
        $autorObraToDelete = null;

        foreach ($autorObras as $autorObra) {
            if ($autorObra->autor_id === $autorId) {
                $autorObraToDelete = $autorObra;
                break;
            }
        }

        if (!$autorObraToDelete) {
            throw new DomainException('Autor não está associado a esta obra');
        }

        if (count($autorObras) <= 1) {
            throw new DomainException('Não é possível remover o último autor da obra');
        }

        $this->autorObraRepository->delete($autorObraToDelete->id);

        return [
            'success' => true,
            'message' => 'Autor removido com sucesso',
            'obra_id' => $obraId,
            'autor_id' => $autorId,
            'autor_nome' => $autor->nome
        ];
    }
}
