<?php
namespace Application\UseCases;

use Application\DTOs\AutorData;
use Domain\Entities\Autor;

use Domain\Repositories\IAutorRepository;
use DomainException;

class UpdateAuthor
{
  
    public function __construct(private IAutorRepository $repo)
    {
    }

    public function execute(AutorData $data, int $id): Autor
    {
        $findAuthorById = $this->repo ->findById($id);
        if(!$findAuthorById){
            throw new DomainException('Autor Não Encontrado.');
        }
           $author = new Autor(
            id: null,
            nome: $data->nome,
            email: $data->email,
            provincia_id: $data->provincia_id,
            numero_identificacao: $data->numero_identificacao,
            autor_representante: $data->representante_legal,
            data_nascimento: $data->data_nascimento,
            telefone:$data->telefone,
            nacionalidade_id: $data->nacionalidade_id,
            pseudonimo: $data->pseudonimo,
            naturalidade: $data->naturalidade,
            nome_pai: $data->nome_pai,
            nome_mae: $data->nome_mae,
            ocupacao: $data->ocupacao,
            endereco: $data->endereco,
            bairro: $data->bairro,
            municipio_id: $data->municipio_id,
            celular: $data->celular,
            site: $data->site,
        );
        return $this->repo->update($author, $id);
    }
}