<?php
namespace Application\UseCases;

use Application\DTOs\UserData;
use Domain\Repositories\UserRepositoryInterface;
use Domain\Entities\User;
use Illuminate\Support\Facades\Hash;

class UpdateUser
{
    public function __construct(private UserRepositoryInterface $repo) {}

    public function execute(int $id, UserData $data): ?User
    {
        $existing = $this->repo->findById($id);
        if (!$existing) return null;

        $existing->name = $data->name;
        $existing->email = $data->email;
        if ($data->password) {
            $existing->password = Hash::make($data->password);
        }
        $existing->role = $data->role;

        return $this->repo->save($existing);
    }
}
