<?php

namespace Application\UseCases;

use Domain\Entities\Vinculo;
use Domain\Repositories\IVinculoRepositoryInterface;

class UpdateVinculo
{
    public function __construct(private IVinculoRepositoryInterface $repo)
    {
    }

    public function execute(int $id, string $designacao): ?Vinculo
    {
        $existing = $this->repo->findById($id);
        if (!$existing) {
            return null;
        }

        $vinculo = new Vinculo($designacao, $id);
        return $this->repo->save($vinculo);
    }
}
