<?php
namespace Domain\Entities;

class Request
{
    public ?int $id;
    public string $certificate_number;
    public \DateTime $registration_date;
    public string $province;
    public string $author_name;
    public string $work_title;
    public string $genre;
    public string $support;
    public string $classification;
    public bool $is_published;

    public function __construct(
        ?int $id,
        string $certificate_number,
        \DateTime $registration_date,
        string $province,
        string $author_name,
        string $work_title,
        string $genre,
        string $support,
        string $classification,
        bool $is_published
    ) {
        // Validação da data
        $this->validateRegistrationDate($registration_date);
        
        // ✅ ATRIBUI OS VALORES (estava faltando isso!)
        $this->id = $id;
        $this->certificate_number = $certificate_number;
        $this->registration_date = $registration_date;
        $this->province = $province;
        $this->author_name = $author_name;
        $this->work_title = $work_title;
        $this->genre = $genre;
        $this->support = $support;
        $this->classification = $classification;
        $this->is_published = $is_published;
    }

    private function validateRegistrationDate(\DateTime $date): void
    {
        $hoje = new \DateTime();
        $hoje->setTime(0, 0, 0);
        
        $dateToCompare = clone $date;
        $dateToCompare->setTime(0, 0, 0);
        
        if ($dateToCompare > $hoje) {
            throw new \InvalidArgumentException(
                "A data de registro não pode ser maior que a data de hoje."
            );
        }
    }
}