<?php

namespace Domain\Repositories;

use Domain\Entities\AutorObra;

interface IAutorObraRepository
{
    public function save(AutorObra $autorObra): AutorObra;
    public function findByObra(int $obra_id): array;
    public function findByAutor(int $autor_id): array;
    public function findById(int $id): ?AutorObra;
    public function update(AutorObra $autorObra): AutorObra;
    public function delete(int $id): void;
    public function deleteByObra(int $obra_id): void;
    public function deleteByAutor(int $autor_id): void;
}
