<?php
namespace Domain\Repositories;

use Application\DTOs\Shared\DataResponse;
use Application\Shared\Search\SearchWithPagination;
use Domain\Entities\Autor;
use Domain\Entities\AutorRepresentanteLegal;

interface IAutorRepository
{
    public function save(Autor $autor, ?AutorRepresentanteLegal $representanteLegal): Autor;
    public function findById(int $id):?DataResponse; 
    public function list(SearchWithPagination $input): DataResponse;
    public function delete(int $id): void;
    public function update(Autor $autor, int $id): Autor;
    public function findRepresentanteLegal(?string $numero_identificacao): ?AutorRepresentanteLegal;
    
}