<?php
namespace Domain\Repositories;

use Domain\Entities\Document;

interface IDocumentRepository
{
    public function save(Document $document): Document;
    public function deleteAuthorDocument(int $documento_id): void;
    public function belongsToAuthor(int $author, int $documento_id): bool;
    public function findById(int $documento_id): ?Document;
}