<?php

namespace Domain\Repositories;

use Domain\Entities\Genero;

interface IGeneroRepositoryInterface
{
    public function save(Genero $genero): Genero;
    public function findById(string $id): ?Genero;
    public function delete(string $id): bool;

    /** @return Genero[] */
    public function all(?string $search = null, int $perPage = 15, int $page = 1, bool $paginate = true): array;
}
