<?php

namespace Domain\Repositories;

use Application\DTOs\Shared\DataResponse;
use Application\Shared\Search\SearchWithPagination;
use Domain\Entities\Request;

interface RequestRepositoryInterface
{
    // Apenas métodos específicos podem
    public function save(Request $request): Request;

    public function findById(int $id): ?Request;

    public function findByEmail(string $email): ?Request;

    public function list(SearchWithPagination $input): DataResponse;

    public function delete(int $id): void;
    public function update(Request $request): Request;
}
