<?php

namespace Infrastructure\Filesystem;

use Domain\Services\IFileStorageService;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;

class LaravelFileStorageService implements IFileStorageService
{
    public function storeFile(UploadedFile $file, string $directory, string $fileName): string
    {
        $path = $file->storeAs($directory, $fileName, 'public');
        return $path;
    }

    public function deleteFile(string $path): void
    {
        if (Storage::disk('public')->exists($path)) {
            Storage::disk('public')->delete($path);
        }
    }

    public function getFileUrl(string $path): string
    {
        return Storage::disk('public')->url($path);
    }
}
