<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClassificacaoModel extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'classificacoes';
    protected $fillable = ['designacao', 'genero_id'];

    public function genero()
    {
        return $this->belongsTo(GeneroModel::class, 'genero_id');
    }

    protected static function newFactory()
    {
        return \Database\Factories\ClassificacaoFactory::new();
    }
}
