<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DocumentoModel extends Model
{
    use SoftDeletes;
    protected $table = 'documentos';
    //
    protected $fillable = [
        'nome',
        'caminho_arquivo',
        'tamanho',
        'tipo_documento_id',
        'extensao'

    ];

        public function autores()
    {
        return $this->belongsToMany(
            AutorModel::class,
            'autor_documentos',
            'documento_id',
            'autor_id'
        )
        ->withPivot(['tipo_documento_id', 'nome', 'descricao'])
        ->withTimestamps();
    }


      public function tipo()
    {
        return $this->belongsTo(TipoDocumentoModel::class, 'tipo_documento_id');
    }


}
