<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ObraDocumento extends Model
{
    use HasFactory;

    protected $table = 'obra_documentos';

    protected $fillable = [
        'obra_id',
        'documento_id',
        'nome_documento',
        'descricao',
        'ordem',
        'obrigatorio'
    ];

    protected $casts = [
        'ordem' => 'integer',
        'obrigatorio' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function obra(): BelongsTo
    {
        return $this->belongsTo(ObraModel::class, 'obra_id');
    }

    public function documento(): BelongsTo
    {
        return $this->belongsTo(DocumentoModel::class, 'documento_id');
    }
}
