<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class ObraModel extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'obras';

    protected $fillable = [
        'titulo',
        'numero_certificado',
        'data_registo',
        'provincia_id',
        'genero_id',
        'suporte',
        'classificacao_id',
        'obra_intelectual',
        'descricao',
        'observacoes'
    ];

    protected $casts = [
        'data_registo' => 'date',
        'obra_intelectual' => 'string',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];

    public function genero(): BelongsTo
    {
        return $this->belongsTo(GeneroModel::class, 'genero_id');
    }

    public function classificacao(): BelongsTo
    {
        return $this->belongsTo(ClassificacaoModel::class, 'classificacao_id');
    }

    public function provincia(): BelongsTo
    {
        return $this->belongsTo(ProvinciaModel::class, 'provincia_id');
    }

    public function autores(): BelongsToMany
    {
        return $this->belongsToMany(
            AutorModel::class,
            'autor_obra',
            'obra_id',
            'autor_id'
        )
        ->withPivot(['vinculo_id', 'observacoes'])
        ->withTimestamps();
    }

    public function documentos(): BelongsToMany
    {
        return $this->belongsToMany(
            DocumentoModel::class,
            'obra_documentos',
            'obra_id',
            'documento_id'
        )
        ->withPivot(['tipo_documento_id', 'ordem'])
        ->withTimestamps();
    }

    public function publicacao(): BelongsTo
    {
        return $this->belongsTo(ObraPublicacaoModel::class, 'id', 'obra_id');
    }
}
