<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ObraPublicacaoModel extends Model
{
    use HasFactory;

    protected $table = 'obra_publicacoes';

    protected $fillable = [
        'obra_id',
        'editora',
        'num_edicao',
        'ano',
        'produtora',
        'local_publicacao',
        'volume'
    ];

    protected $casts = [
        'obra_id' => 'integer',
        'ano' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function obra(): BelongsTo
    {
        return $this->belongsTo(ObraModel::class, 'obra_id');
    }
}
