<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RequestModel extends Model
{
    use HasFactory, SoftDeletes;

    // Nome da tabela
    protected $table = 'requests';

    // Chave primária é UUID
    protected $keyType = 'string';

    protected $fillable = [
        'certificate_number',
        'registration_date',
        'province',
        'author_name',
        'work_title',
        'genre',
        'support',
        'classification',
        'is_published',
    ];

    protected $casts = [
        'registration_date' => 'date',
        'is_published' => 'boolean',
    ];

    protected static function newFactory()
    {
        return \Database\Factories\RequestFactory::new();
    }
}
