<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TipoDocumentoModel extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'tipo_documentos';
    //
    protected $fillable = [
        'nome',
        'descricao',
    ];

    protected static function newFactory()
    {
        return \Database\Factories\TipoDocumentoFactory::new();
    }

          public function documentos()
    {
        return $this->hasMany(DocumentoModel::class, 'tipo_documento_id');
    }
}
