<?php

namespace Infrastructure\Providers;

use App\Infrastructure\Filesystem\LaravelFileDelete;
use Infrastructure\Filesystem\LaravelFileStorageService;
use Domain\Repositories\IAutorDocumentRepository;
use Domain\Repositories\IAutorRepository;
use Domain\Repositories\IClassificacaoRepositoryInterface;
use Domain\Repositories\IDocumentRepository;
use Domain\Repositories\IGeneroRepositoryInterface;
use Domain\Repositories\IMunicipioRepository;
use Domain\Repositories\INacionalityRepository;
use Domain\Repositories\IProvinceRepository;
use Domain\Repositories\ITypeDocumentRepository;
use Domain\Repositories\IVinculoRepositoryInterface;
use Domain\Repositories\IObraRepository;
use Domain\Repositories\IAutorObraRepository;
use Domain\Repositories\IObraPublicacaoRepository;
use Domain\Repositories\RequestRepositoryInterface;
use Domain\Repositories\UserRepositoryInterface;
use Illuminate\Support\ServiceProvider;
use Domain\Services\IFileDelete;
use Domain\Services\IFileStorageService;
use Infrastructure\Persistence\Repositories\EloquentAuthorDocumentRepository;
use Infrastructure\Persistence\Repositories\EloquentAutorRepository;
use Infrastructure\Persistence\Repositories\EloquentClassificacaoRepository;
use Infrastructure\Persistence\Repositories\EloquentDocumentRepository;
use Infrastructure\Persistence\Repositories\EloquentGeneroRepository;
use Infrastructure\Persistence\Repositories\EloquentMunicipioRepository;
use Infrastructure\Persistence\Repositories\EloquentNacionalityRepository;
use Infrastructure\Persistence\Repositories\EloquentProvinceRepository;
use Infrastructure\Persistence\Repositories\EloquentRequestRepository;
use Infrastructure\Persistence\Repositories\EloquentTypeDocumentRepository;
use Infrastructure\Persistence\Repositories\EloquentUserRepository;
use Infrastructure\Persistence\Repositories\EloquentVinculoRepository;
use Infrastructure\Persistence\Repositories\EloquentObraRepository;
use Infrastructure\Persistence\Repositories\EloquentAutorObraRepository;
use Infrastructure\Persistence\Repositories\EloquentObraPublicacaoRepository;

class BindingsServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->bind(UserRepositoryInterface::class, EloquentUserRepository::class);
        $this->app->bind(RequestRepositoryInterface::class, EloquentRequestRepository::class);
        $this->app->bind(IGeneroRepositoryInterface::class, EloquentGeneroRepository::class);
        $this->app->bind(IAutorRepository::class, EloquentAutorRepository::class);
        $this->app->bind(IDocumentRepository::class, EloquentDocumentRepository::class);
        $this->app->bind(IAutorDocumentRepository::class, EloquentAuthorDocumentRepository::class);
        $this->app->bind(IProvinceRepository::class, EloquentProvinceRepository::class);
        $this->app->bind(ITypeDocumentRepository::class, EloquentTypeDocumentRepository::class);
        $this->app->bind(IClassificacaoRepositoryInterface::class, EloquentClassificacaoRepository::class);
        $this->app->bind(IVinculoRepositoryInterface::class, EloquentVinculoRepository::class);
        $this->app->bind(INacionalityRepository::class, EloquentNacionalityRepository::class);
        $this->app->bind(IMunicipioRepository::class,EloquentMunicipioRepository::class);
        $this->app->bind(IObraRepository::class, EloquentObraRepository::class);
        $this->app->bind(IAutorObraRepository::class, EloquentAutorObraRepository::class);
        $this->app->bind(IObraPublicacaoRepository::class, EloquentObraPublicacaoRepository::class);
        $this->app->bind(IFileDelete::class, LaravelFileDelete::class);
        $this->app->bind(IFileStorageService::class, LaravelFileStorageService::class);

    }
}
