<?php
namespace UI\Http\Controllers;

use App\Http\Controllers\Controller;
use Application\Shared\Search\Paginate;
use Application\Shared\Search\Search;
use Application\Shared\Search\SearchWithPagination;
use Domain\Repositories\INacionalityRepository;
use Domain\Repositories\IProvinceRepository;

class NacionalityController extends Controller
{
    public function __construct(
        private INacionalityRepository $repo
    ) {}

    /**
     * @OA\Get(
     *   path="/api/v1/nacionalidades/all",
     *   tags={"Naciolidade"},
     *   @OA\Response(response=200, description="Get province"),
     *   @OA\Response(response=404, description="Not found")
     * )
     */
    public function drowpDown()
    { 
         $search = new Search([]);
        
        $paginate = new Paginate(['withPagination' => false]);

        $input = new SearchWithPagination($search, $paginate);

        $result = $this->repo->list($input);

        return response()->json($result->toArray());
    }
}