<?php

namespace UI\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreAutorRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
    
            'nome' => 'required|string|max:255',
            'email' => 'required|email|unique:autor,email',
            'provincia_id' => 'required|integer|exists:provincias,id',
            'numero_identificacao' => 'required|string|unique:autor,numero_identificacao',
            'telefone' => 'required|string|max:20|unique:autor,telefone',
            'data_nascimento' => 'required|date',
            'nacionalidade_id' => 'required|integer|exists:nacionalidades,id',
            'pseudonimo' => 'nullable|string|max:255',
            'naturalidade' => 'nullable|string|max:255',
            'nome_pai' => 'nullable|string|max:255',
            'nome_mae' => 'nullable|string|max:255',
            'ocupacao' => 'nullable|string|max:255',
            'endereco' => 'nullable|string|max:255',
            'bairro' => 'nullable|string|max:255',
            'municipio_id' => 'required|integer|exists:municipios,id',
            'celular' => 'nullable|string|max:20',
            'site' => 'nullable|string|max:255',

            
            // conforme Swagger: remover email, telefone e provincia_id
            'representante_nome' => 'nullable|string|max:255',
            'representante_grau_parentesco' => 'nullable|string|max:255',
            'representante_numero_identificacao' => 'nullable|string|max:100',

            // 📄 Documentos (vários arquivos)
            'documentos' => 'nullable|array',
            'documentos.*.file' => 'required_with:documentos|file|max:10240', // 10MB
            'documentos.*.tipo_documento_id' => 'required_with:documentos|integer|exists:tipo_documentos,id',
            'documentos.*.nome' => 'nullable|string|max:255',
            'documentos.*.caminho_arquivo' => 'nullable|string|max:500',
            'documentos.*.tamanho' => 'nullable|string|max:50',
            'documentos.*.extensao' => 'nullable|string|max:20',
        ];
    }

    public function messages(): array
    {
        return [
            // Autor
            'nome.required' => 'O nome do autor é obrigatório.',
            'email.required' => 'O e-mail é obrigatório.',
            'email.unique' => 'Este e-mail já está em uso.',
            'numero_identificacao.required' => 'O número do documento é obrigatório.',
            'numero_identificacao.unique' => 'Este número de documento já está em uso.',
            'provincia_id.exists' => 'A província selecionada não é válida.',
            'municipio_id.exists' => 'O Municipio selecionada não é válida.',
            'nacionalidade_id.exists' => 'A nacionalidade selecionada não é válida.',


            // Documentos
            'documentos.*.file.required_with' => 'Cada documento deve ter um arquivo.',
            'documentos.*.file.max' => 'O arquivo não pode exceder 10MB.',
            'documentos.*.tipo_documento_id.exists' => 'O tipo de documento informado não é válido.',
        ];
    }
}
