<?php

namespace UI\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateAutorRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true; // Permitir por enquanto — ajuste se usar políticas
    }

    public function rules(): array
    {
        $autorId = $this->route('id'); // ID do autor atual para ignorar nos campos únicos

        return [
            // 🧍‍♂️ Dados do autor
            'nome' => 'required|string|max:255',
            'email' => [
                'required',
                'email',
                Rule::unique('autores', 'email')->ignore($autorId),
            ],
            'provincia_id' => 'required|integer|exists:provincias,id',
            'numero_documento' => [
                'required',
                'string',
                Rule::unique('autores', 'numero_documento')->ignore($autorId),
            ],
            'telefone' => 'required|string|max:20',
            'data_nascimento' => 'required|date',
            'nacionalidade_id' => 'required|integer|exists:nacionalidades,id',
            'pseudonimo' => 'nullable|string|max:255',
            'naturalidades' => 'nullable|string|max:255',
            'nome_pai' => 'nullable|string|max:255',
        'nome_mae' => 'nullable|string|max:255',
            'ocupacao' => 'nullable|string|max:255',
            'endereco' => 'nullable|string|max:255',
            'bairro' => 'nullable|string|max:255',
            'municipio' => 'nullable|string|max:255',
            'celular' => 'nullable|string|max:20',
            'site' => 'nullable|string|max:255',

            // 👩‍🦰 Representante legal (opcional)
            'representante' => 'nullable|array',
            'representante.nome' => 'required_with:representante|string|max:255',
            'representante.grau_parentesco' => 'required_with:representante|string|max:255',
            'representante.numero_identificacao' => 'required_with:representante|string|max:100',
        ];
    }

    public function messages(): array
    {
        return [
            // Autor
            'nome.required' => 'O nome do autor é obrigatório.',
            'email.required' => 'O e-mail é obrigatório.',
            'email.unique' => 'Este e-mail já está em uso.',
            'numero_documento.required' => 'O número do documento é obrigatório.',
            'numero_documento.unique' => 'Este número de documento já está em uso.',
            'provincia_id.exists' => 'A província selecionada não é válida.',
            'nacionalidade_id.exists' => 'A nacionalidade selecionada não é válida.',
            'telefone.required' => 'O telefone é obrigatório.',
            'data_nascimento.required' => 'A data de nascimento é obrigatória.',

            // Representante legal
            'representante.required_with' => 'Os dados do representante legal estão incompletos.',
            'representante.nome.required_with' => 'O nome do representante é obrigatório.',
            'representante.grau_parentesco.required_with' => 'O grau de parentesco é obrigatório.',
            'representante.numero_identificacao.required_with' => 'O número de identificação do representante é obrigatório.',
        ];
    }
}
