<?php
namespace UI\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateUserRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $id = $this->route('user');

        return [
            'name' => 'required|string|max:255',
            'email' => ['required','email', Rule::unique('users','email')->ignore($id)],
            'password' => 'nullable|string|min:6|confirmed',
            'role' => 'sometimes|string'
        ];
    }
}
