<?php

use Illuminate\Support\Facades\Route;

$versionsPath = __DIR__;

foreach (glob($versionsPath . '/v*', GLOB_ONLYDIR) as $versionDir) {
    $version = basename($versionDir);

    Route::prefix($version)
        ->group(function () use ($versionDir) {
            foreach (glob($versionDir . '/*.php') as $file) {
                require $file;
            }
        });
}
