<?php

use Illuminate\Support\Facades\Route;
use UI\Http\Controllers\ObraController;

Route::apiResource('obras', ObraController::class);

Route::get('obras/autor/{autor_id}', [ObraController::class, 'findByAuthor'])
    ->name('obras.by-author');

Route::post('obras/{id}/documentos', [ObraController::class, 'addDocumento'])
    ->name('obras.add-documento');
Route::post('obras/{id}/autores', [ObraController::class, 'addAutor'])
    ->name('obras.add-autor');

Route::post('obras/{id}/publicacao', [ObraController::class, 'managePublicacao'])
    ->name('obras.manage-publicacao');
Route::get('obras/{id}/publicacao', [ObraController::class, 'getPublicacao'])
    ->name('obras.get-publicacao');

Route::delete('obras/{id}/documentos/{documento_id}', [ObraController::class, 'removeDocumento'])
    ->name('obras.remove-documento');
Route::delete('obras/{id}/autores/{autor_id}', [ObraController::class, 'removeAutor'])
    ->name('obras.remove-autor');
