<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Infrastructure\Persistence\Eloquent\Models\GeneroModel;

/**
 * @extends Factory<GeneroModel>
 */
class ClassificacaoFactory extends Factory
{
    protected $model = ClassificacaoModel::class;

    public function definition(): array
    {
        return [
            'designacao' => $this->faker->randomElement([
                'Tese', 'Música', 'Poesia', 'Dança', 'Teatro', 'Pintura'
            ]),
            'genero_id' => GeneroModel::factory(),
        ];
    }
}
