<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Infrastructure\Persistence\Eloquent\Models\RequestModel;

/**
 * @extends Factory<RequestModel>
 */
class RequestFactory extends Factory
{
    protected $model = RequestModel::class;

    public function definition(): array
    {
        return [
            'certificate_number' => strtoupper($this->faker->bothify('CERT-###')),
            'registration_date' => $this->faker->date(),
            'province' => $this->faker->randomElement([
                'Luanda', 'Benguela', 'Huambo', 'Namibe', 'Uíge', 'Malanje', 'Cabinda'
            ]),
            'author_name' => $this->faker->name(),
            'work_title' => $this->faker->sentence(3),
            'genre' => $this->faker->randomElement([
                'Literatura', 'Música', 'Poesia', 'Dança', 'Teatro', 'Pintura'
            ]),
            'support' => $this->faker->randomElement(['Digital', 'Físico']),
            'classification' => $this->faker->randomElement(['Adulto', 'Infantil', 'Juvenil']),
            'is_published' => $this->faker->boolean(),
        ];
    }
}
