<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Infrastructure\Persistence\Eloquent\Models\GeneroModel;

/**
 * @extends Factory<GeneroModel>
 */
class VinculoFactory extends Factory
{
    protected $model = VinculoModel::class;

    public function definition(): array
    {
        return [
            'designacao' => $this->faker->randomElement([
                'Autor', 'Interprete', 'Dublador', 'Tradutor', 'Adaptador', 'Compositor', 'Arranjador'
            ])
        ];
    }
}
