<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
       Schema::create('autor_representante_legal', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('numero_identificacao');
            $table->string('email');
            $table->foreignId('provincia_id')
                ->constrained('provincias')
                ->nullable()
                ->onDelete('cascade');
            $table->string('telefone');
            $table->string('grau_parentesco', 100);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
