<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('obras', function (Blueprint $table) {
            $table->id();
            $table->string('titulo');
            $table->string('numero_certificado')->unique();
            $table->date('data_registo');
            $table->foreignId('provincia_id')->constrained('provincias')->onDelete('cascade');
            $table->foreignId('genero_id')->constrained('generos')->onDelete('cascade');
            $table->string('suporte');
            $table->foreignId('classificacao_id')->constrained('classificacoes')->onDelete('cascade');
            $table->enum('obra_intelectual', ['INEDITA', 'PUBLICADA'])
                ->default('INEDITA')
                ->comment('Status da obra intelectual: INEDITA ou PUBLICADA');
            $table->text('descricao')->nullable();
            $table->text('observacoes')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('obras');
    }
};
