<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('autor_documentos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('autor_id')
                ->constrained('autores')
                ->onDelete('cascade');

      
            $table->foreignId('documento_id')
                ->constrained('documentos')
                ->onDelete('cascade');



            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('autor_documentos');
    }
};
