<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pedidos', function (Blueprint $table) {
            $table->id();
            $table->string('numero_certificado');
            $table->date('data_registo');
            $table->string('provincia');
            $table->string('autor');
            $table->string('titulo_obra');
            $table->string('genero')->nullable();
            $table->string('suporte')->nullable();
            $table->string('classificacao');
            $table->boolean('esta_publicada');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pedidos');
    }
};
