<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        Schema::create('autor', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('numero_identificacao');
            $table->string('email');
            $table->foreignId('provincia_id')
                ->constrained('provincias')
                ->onDelete('cascade');
            $table->foreignId('representante_legal_id')
                ->constrained('autor_representante_legal')
                ->nullable()
                ->onDelete('cascade');
            $table->string('telefone');
            $table->date('data_nascimento');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
        Schema::dropIfExists('autor');
    }
};
