<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('autor', function (Blueprint $table) {
            //
            $table->string('pseudonimo', 100);
            $table->string('naturalidades', 100);
            $table->string('nome_pai', 100);
            $table->string('nome_mae', 100);
            $table->string('ocupacao', 100);
            $table->string('enderenco', 200);
            $table->string('bairro', 200);
            $table->string('municipio', 200);
            $table->foreignId('nacionalidade_id')
                ->constrained('nacionalidades')
                ->onDelete('cascade');
            $table->dropColumn('numero_identificacao');
            $table->string('numero_documento');
            $table->string('celular', 100)->nullable();
            $table->string('site', 100)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('autor', function (Blueprint $table) {
            //
            $table->dropColumn([
                'pseudonimo',
                'naturalidades',
                'nome_pai',
                'nome_mae',
                'ocupacao',
                'enderenco',
                'bairro',
                'municipio',
            ]);

            $table->string('numero_identificacao');
        });
    }
};
