<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('obras', function (Blueprint $table) {
            // Remover o campo esta_publicada
            $table->dropColumn('esta_publicada');

            // Adicionar o novo campo obra_intelectual como enum
            $table->enum('obra_intelectual', ['INEDITA', 'PUBLICADA'])
                ->default('INEDITA')
                ->after('classificacao_id')
                ->comment('Status da obra intelectual: INEDITA ou PUBLICADA');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('obras', function (Blueprint $table) {
            // Remover o campo obra_intelectual
            $table->dropColumn('obra_intelectual');

            // Restaurar o campo esta_publicada
            $table->boolean('esta_publicada')->default(false)->after('classificacao_id');
        });
    }
};
