<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Infrastructure\Persistence\Eloquent\Models\AutorRepresentanteLegalModel;

class AutorRepresentanteLegalSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $representantes = [
            [
                'nome' => 'Representante Legal Padrão',
                'numero_identificacao' => 'REP001',
                'grau_parentesco' => 'Pai'
            ],
            [
                'nome' => 'Representante Legal Secundário',
                'numero_identificacao' => 'REP002',
                'grau_parentesco' => 'Mãe'
            ],
            [
                'nome' => 'Representante Legal Terciário',
                'numero_identificacao' => 'REP003',
                'grau_parentesco' => 'Tutor'
            ]
        ];

        foreach ($representantes as $representante) {
            AutorRepresentanteLegalModel::firstOrCreate(
                ['numero_identificacao' => $representante['numero_identificacao']],
                $representante
            );
        }
    }
}
