<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Infrastructure\Persistence\Eloquent\Models\ClassificacaoModel;

class ClassificacaoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $classificacoes = [
            ['designacao' => 'Ficção', 'genero_id' => 1],
            ['designacao' => 'Não-ficção', 'genero_id' => 1],
            ['designacao' => 'Poesia', 'genero_id' => 1],
            ['designacao' => 'Drama', 'genero_id' => 1],
            ['designacao' => 'Romance', 'genero_id' => 1],
            ['designacao' => 'Mistério', 'genero_id' => 1],
            ['designacao' => 'Fantasia', 'genero_id' => 1],
            ['designacao' => 'Ciência Ficção', 'genero_id' => 1],
            ['designacao' => 'História', 'genero_id' => 1],
            ['designacao' => 'Biografia', 'genero_id' => 1]
        ];

        foreach ($classificacoes as $classificacao) {
            ClassificacaoModel::firstOrCreate(
                ['designacao' => $classificacao['designacao']],
                $classificacao
            );
        }
    }
}
