<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NacionalidadeSeeder extends Seeder
{
    public function run(): void
    {
        $nacionalidades = [
            ['nome' => 'Afegã', 'codigo_iso' => 'AF'],
            ['nome' => 'Sul-africana', 'codigo_iso' => 'ZA'],
            ['nome' => 'Alemã', 'codigo_iso' => 'DE'],
            ['nome' => 'Angolana', 'codigo_iso' => 'AO'],
            ['nome' => 'Argentina', 'codigo_iso' => 'AR'],
            ['nome' => 'Australiana', 'codigo_iso' => 'AU'],
            ['nome' => 'Belga', 'codigo_iso' => 'BE'],
            ['nome' => 'Brasileira', 'codigo_iso' => 'BR'],
            ['nome' => 'Cabo-verdiana', 'codigo_iso' => 'CV'],
            ['nome' => 'Canadense', 'codigo_iso' => 'CA'],
            ['nome' => 'Chilena', 'codigo_iso' => 'CL'],
            ['nome' => 'Chinesa', 'codigo_iso' => 'CN'],
            ['nome' => 'Colombiana', 'codigo_iso' => 'CO'],
            ['nome' => 'Congolesa', 'codigo_iso' => 'CD'],
            ['nome' => 'Coreana', 'codigo_iso' => 'KR'],
            ['nome' => 'Cubana', 'codigo_iso' => 'CU'],
            ['nome' => 'Dinamarquesa', 'codigo_iso' => 'DK'],
            ['nome' => 'Egípcia', 'codigo_iso' => 'EG'],
            ['nome' => 'Espanhola', 'codigo_iso' => 'ES'],
            ['nome' => 'Estadunidense', 'codigo_iso' => 'US'],
            ['nome' => 'Francesa', 'codigo_iso' => 'FR'],
            ['nome' => 'Portuguesa', 'codigo_iso' => 'PT'],
            ['nome' => 'Italiana', 'codigo_iso' => 'IT'],
            ['nome' => 'Moçambicana', 'codigo_iso' => 'MZ'],
            ['nome' => 'Nigeriana', 'codigo_iso' => 'NG'],
            ['nome' => 'Sueca', 'codigo_iso' => 'SE'],
            ['nome' => 'Suíça', 'codigo_iso' => 'CH'],
            ['nome' => 'Turca', 'codigo_iso' => 'TR'],
            ['nome' => 'Zimbabuense', 'codigo_iso' => 'ZW'],
        ];


        DB::table('nacionalidades')->upsert(
            $nacionalidades,
            ['codigo_iso'], // campo usado para identificar duplicatas
            ['nome']        // campo(s) que serão atualizados se já existir
        );
    }
}
