<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Infrastructure\Persistence\Eloquent\Models\AutorObraModel;
use Infrastructure\Persistence\Eloquent\Models\ObraDocumentoModel;
use Infrastructure\Persistence\Eloquent\Models\ObraModel;

class ObraSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $obras = [
            [
                'titulo' => 'Memórias de um Sonho',
                'numero_certificado' => 'CERT-2024-001',
                'data_registo' => '2024-01-15',
                'provincia_id' => 1, // Luanda
                'genero_id' => 1, // Literatura
                'suporte' => 'Livro',
                'classificacao_id' => 1, // Ficção
                'obra_intelectual' => 'PUBLICADA',
                'descricao' => 'Uma obra de ficção que narra as aventuras de um jovem em busca de seus sonhos.',
                'observacoes' => 'Primeira obra do autor, recebeu prêmio literário regional.'
            ],
            [
                'titulo' => 'Cantos da Terra',
                'numero_certificado' => 'CERT-2024-002',
                'data_registo' => '2024-02-20',
                'provincia_id' => 2, // Benguela
                'genero_id' => 2, // Música
                'suporte' => 'CD',
                'classificacao_id' => 2, // Não-ficção
                'obra_intelectual' => 'PUBLICADA',
                'descricao' => 'Coletânea de músicas tradicionais angolanas com arranjos modernos.',
                'observacoes' => 'Projeto cultural financiado pelo Ministério da Cultura.'
            ],
            [
                'titulo' => 'Retratos Urbanos',
                'numero_certificado' => 'CERT-2024-003',
                'data_registo' => '2024-03-10',
                'provincia_id' => 1, // Luanda
                'genero_id' => 3, // Artes Visuais
                'suporte' => 'Exposição',
                'classificacao_id' => 3, // Poesia
                'obra_intelectual' => 'INEDITA',
                'descricao' => 'Série fotográfica documentando a vida urbana em Luanda.',
                'observacoes' => 'Em processo de finalização para exposição.'
            ],
            [
                'titulo' => 'O Tempo das Palmeiras',
                'numero_certificado' => 'CERT-2024-004',
                'data_registo' => '2024-04-05',
                'provincia_id' => 3, // Huambo
                'genero_id' => 1, // Literatura
                'suporte' => 'Livro',
                'classificacao_id' => 4, // Drama
                'obra_intelectual' => 'PUBLICADA',
                'descricao' => 'Peça teatral que retrata a história de uma família angolana.',
                'observacoes' => 'Adaptada para teatro e apresentada em várias cidades.'
            ],
            [
                'titulo' => 'Sinfonia do Deserto',
                'numero_certificado' => 'CERT-2024-005',
                'data_registo' => '2024-05-12',
                'provincia_id' => 5, // Namibe
                'genero_id' => 2, // Música
                'suporte' => 'Partitura',
                'classificacao_id' => 5, // Romance
                'obra_intelectual' => 'INEDITA',
                'descricao' => 'Composição musical inspirada nas paisagens do deserto do Namibe.',
                'observacoes' => 'Aguardando aprovação para publicação.'
            ],
            [
                'titulo' => 'Cores de Angola',
                'numero_certificado' => 'CERT-2024-006',
                'data_registo' => '2024-06-18',
                'provincia_id' => 6, // Huíla
                'genero_id' => 3, // Artes Visuais
                'suporte' => 'Pintura',
                'classificacao_id' => 6, // Mistério
                'obra_intelectual' => 'PUBLICADA',
                'descricao' => 'Coleção de pinturas a óleo retratando a diversidade cultural angolana.',
                'observacoes' => 'Exposição itinerante pelo país.'
            ],
            [
                'titulo' => 'Histórias do Mar',
                'numero_certificado' => 'CERT-2024-007',
                'data_registo' => '2024-07-25',
                'provincia_id' => 2, // Benguela
                'genero_id' => 1, // Literatura
                'suporte' => 'Livro',
                'classificacao_id' => 7, // Fantasia
                'obra_intelectual' => 'PUBLICADA',
                'descricao' => 'Contos infantis sobre aventuras marítimas.',
                'observacoes' => 'Livro didático adotado em escolas primárias.'
            ],
            [
                'titulo' => 'Dança dos Ventos',
                'numero_certificado' => 'CERT-2024-008',
                'data_registo' => '2024-08-30',
                'provincia_id' => 4, // Bié
                'genero_id' => 5, // Teatro
                'suporte' => 'Performance',
                'classificacao_id' => 8, // Ciência Ficção
                'obra_intelectual' => 'INEDITA',
                'descricao' => 'Espetáculo de dança contemporânea inspirado na cultura local.',
                'observacoes' => 'Em ensaios para estreia nacional.'
            ],
            [
                'titulo' => 'Luzes da Cidade',
                'numero_certificado' => 'CERT-2024-009',
                'data_registo' => '2024-09-14',
                'provincia_id' => 1, // Luanda
                'genero_id' => 4, // Cinema
                'suporte' => 'Filme',
                'classificacao_id' => 9, // História
                'obra_intelectual' => 'PUBLICADA',
                'descricao' => 'Documentário sobre o desenvolvimento urbano de Luanda.',
                'observacoes' => 'Exibido em festivais internacionais de cinema.'
            ],
            [
                'titulo' => 'Cantos de Liberdade',
                'numero_certificado' => 'CERT-2024-010',
                'data_registo' => '2024-10-22',
                'provincia_id' => 7, // Malanje
                'genero_id' => 2, // Música
                'suporte' => 'Álbum',
                'classificacao_id' => 10, // Biografia
                'obra_intelectual' => 'PUBLICADA',
                'descricao' => 'Álbum musical com canções sobre a independência de Angola.',
                'observacoes' => 'Lançado em comemoração aos 50 anos da independência.'
            ]
        ];

        foreach ($obras as $index => $obraData) {
            $obra = ObraModel::firstOrCreate(
                ['numero_certificado' => $obraData['numero_certificado']],
                $obraData
            );

            $autorId = ($index % 10) + 1;
            $vinculoId = ($index % 10) + 1;

            AutorObraModel::firstOrCreate(
                [
                    'autor_id' => $autorId,
                    'obra_id' => $obra->id,
                    'vinculo_id' => $vinculoId
                ],
                [
                    'observacoes' => 'Autor principal da obra ' . $obra->titulo,
                    'created_at' => now(),
                    'updated_at' => now()
                ]
            );

            $documentoId = ($index % 10) + 1;

            ObraDocumentoModel::firstOrCreate(
                [
                    'obra_id' => $obra->id,
                    'documento_id' => $documentoId
                ],
                [
                    'tipo_documento_id' => ($index % 8) + 1, // Usar tipos de documento de ID 1 a 8
                    'ordem' => 1,
                    'created_at' => now(),
                    'updated_at' => now()
                ]
            );
        }
    }
}
