<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Infrastructure\Persistence\Eloquent\Models\TipoDocumentoModel;

class TipoDocumentoSeeder extends Seeder
{

    public function run(): void
    {
        $tiposDocumentos = [
            ['nome' => 'Contrato de Publicação', 'descricao' => 'Contrato de publicação da obra'],
            ['nome' => 'Manuscrito', 'descricao' => 'Manuscrito original da obra'],
            ['nome' => 'Certificado de Registro', 'descricao' => 'Certificado de registro da obra'],
            ['nome' => 'Documento de Identidade', 'descricao' => 'Documento de identificação do autor'],
            ['nome' => 'Comprovante de Pagamento', 'descricao' => 'Comprovante de pagamento de taxas'],
            ['nome' => 'Autorização de Uso', 'descricao' => 'Autorização para uso da obra'],
            ['nome' => 'Termo de Responsabilidade', 'descricao' => 'Termo de responsabilidade do autor'],
            ['nome' => 'Outros', 'descricao' => 'Outros documentos relacionados']
        ];

        foreach ($tiposDocumentos as $tipo) {
            TipoDocumentoModel::firstOrCreate(
                ['nome' => $tipo['nome']],
                $tipo
            );
        }
    }
}
